/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.time;

import com.mlib.Utility;
import com.mlib.config.DoubleConfig;
import com.mlib.contexts.OnClientTick;
import com.mlib.contexts.OnServerTick;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Priority;
import com.mlib.modhelper.AutoInstance;
import javax.annotation.Nonnegative;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.DistExecutor;

public class TimeHelper {
    static long clientCounter = 1L;
    static long serverCounter = 1L;

    public static boolean hasClientTicksPassed(@Nonnegative int ticks) {
        return clientCounter % (long)ticks == 0L;
    }

    public static boolean hasClientSecondsPassed(@Nonnegative double seconds) {
        return TimeHelper.hasClientTicksPassed(Utility.secondsToTicks(seconds));
    }

    public static boolean hasClientSecondsPassed(DoubleConfig config) {
        return TimeHelper.hasClientTicksPassed(config.asTicks());
    }

    public static long getClientTicks() {
        return clientCounter;
    }

    public static boolean hasServerTicksPassed(@Nonnegative int ticks) {
        return serverCounter % (long)ticks == 0L;
    }

    public static boolean hasServerSecondsPassed(@Nonnegative double seconds) {
        return TimeHelper.hasServerTicksPassed(Utility.secondsToTicks(seconds));
    }

    public static boolean hasServerSecondsPassed(DoubleConfig config) {
        return TimeHelper.hasServerTicksPassed(config.asTicks());
    }

    public static long getServerTicks() {
        return serverCounter;
    }

    public static float getPartialTicks() {
        return ((Float)DistExecutor.unsafeRunForDist(() -> () -> Float.valueOf(Minecraft.m_91087_().getPartialTick()), () -> () -> Float.valueOf(0.0f))).floatValue();
    }

    @AutoInstance
    public static class Updater {
        public Updater() {
            OnClientTick.listen(data -> ++clientCounter).priority(Priority.HIGHEST).addCondition(Condition.isEndPhase());
            OnServerTick.listen(data -> ++serverCounter).priority(Priority.HIGHEST).addCondition(Condition.isEndPhase());
        }
    }
}

